const promptToggle = (element, toAdd, toRemove) => {
  element.classList.add(toAdd);
  element.classList.remove(toRemove);
};

const statusPrompt = {
  get: () => {
    return localStorage.getItem("statusPrompt") || null;
  },
  set: (status) => {
    localStorage.setItem("statusPrompt", status);
    return;
  },
};

window.onload = (e) => {
  // Set serviceWorker
  if ("serviceWorker" in navigator) {
    navigator.serviceWorker.register("sw.js").then(
      (registration) => {
        // Registration was successful 😜
        console.log(
          "ServiceWorker registration successful with scope: ",
          registration.scope
        );
      },
      (err) => {
        // registration failed 😯
        console.log("ServiceWorker registration failed: ", err);
      }
    );
  }

  // if ('serviceWorker' in navigator) {
  //   window.addEventListener('load', function() {
  //     navigator.serviceWorker.register('<?= ruta ?>sw.js')
  //       .then(function() {
  //         console.log('ServiceWorker registered!');
  //       })
  //       .catch(function(err) {
  //         console.log('ServiceWorker failed :(', err);
  //       });
  //   });
  // }

  //  document.addEventListener('touchstart', onTouchStart, {passive: true});

  // buttonInstall.addEventListener('click', (e) => {
  //     // Hide the app provided install promotion
  //     hideMyInstallPromotion();
  //     // Show the install prompt
  //     deferredPrompt.prompt();
  //     // Wait for the user to respond to the prompt
  //     deferredPrompt.userChoice.then((choiceResult) => {
  //       if (choiceResult.outcome === 'accepted') {
  //         console.log('User accepted the install prompt');
  //       } else {
  //         console.log('User dismissed the install prompt');
  //       }
  //     })
  //   });

  // Declare init HTML elements

  const prompt = document.querySelector("#prompt");
  const buttonAdd = document.querySelector("#buttonAdd");
  const buttonCancel = document.querySelector("#buttonCancel");

  // Add all cats from array into list

  let deferredPrompt;
  window.addEventListener("beforeinstallprompt", (e) => {
    // Evita que Chrome 67 y versiones anteriores muestren automáticamente el mensaje
    e.preventDefault();
    // Guarde el evento para que se pueda activar más tarde.
    deferredPrompt = e;

    if (!statusPrompt.get()) {
      // Change status prompt
      promptToggle(prompt, "show", "hide");
    }
  });

  // window.addEventListener('appinstalled', (e) => {
  //   console.log('ok')
  //   buttonAdd.style.display = 'none';
  // });

  // Add event click function for Cancel button
  buttonCancel.addEventListener("click", (e) => {
    // Change status prompt
    promptToggle(prompt, "hide", "show");
    // Set status prompt to dismissed
    statusPrompt.set("dismissed");
  });

  // Función de clic para agregar evento para el botón Agregar
  buttonAdd.addEventListener("click", (e) => {
    // Change status prompt
    promptToggle(prompt, "hide", "show");
    // Mostrar el aviso
    deferredPrompt.prompt();
    // Espere a que el usuario responda a la solicitud
    deferredPrompt.userChoice.then((choiceResult) => {
      if (choiceResult.outcome === "accepted") {
        statusPrompt.set("accepted");
        console.log("User accepted the A2HS prompt");
      } else {
        statusPrompt.set("dismissed");
        console.log("User dismissed the A2HS prompt");
      }
      deferredPrompt = null;
    });
  });

  window.addEventListener("appinstalled", (e) => {
    console.log("a2hs installed");
    buttonAdd.style.display = 'none';
  });

  if (window.matchMedia("(display-mode: standalone)").matches) {
    console.log("display-mode is standalone");
    buttonAdd.style.display = 'none';

  }
};
